(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     44548,       1250]*)
(*NotebookOutlinePosition[     45451,       1280]*)
(*  CellTagsIndexPosition[     45407,       1276]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Forced Oscillation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Example 6.7 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, t, x]\), "\n", 
    RowBox[{\(L[t_, x_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["x", "\[DoublePrime]",
            MultilineFunction->None], "[", "t", "]"}], "+", 
        RowBox[{"6", " ", 
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], 
        "+", \(10\ x[t]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(10\ x[t]\), "+", 
      RowBox[{"6", " ", 
        RowBox[{
          SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(solnRule = DSolve[{L[t, x] == 2\ Cos[3\ t]}, x[t], t]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{x[
            t] \[Rule] \[ExponentialE]\^\(\(-3\)\ t\)\ C[2]\ Cos[
                t] + \[ExponentialE]\^\(\(-3\)\ t\)\ C[1]\ Sin[t] + 
            1\/325\ \((\(-50\)\ Cos[t]\ Cos[2\ t] + 52\ Cos[t]\ Cos[4\ t] + 
                  75\ Cos[2\ t]\ Sin[t] + 39\ Cos[4\ t]\ Sin[t] + 
                  75\ Cos[t]\ Sin[2\ t] + 50\ Sin[t]\ Sin[2\ t] - 
                  39\ Cos[t]\ Sin[4\ t] + 
                  52\ Sin[t]\ Sin[4\ t])\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[soln]\), "\n", 
    \(soln[t_] = 
      x[t] /. solnRule\[LeftDoubleBracket]1\[RightDoubleBracket] // 
        Simplify\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-3\)\ t\)\ C[2]\ Cos[t] + 
      2\/325\ Cos[3\ t] + \[ExponentialE]\^\(\(-3\)\ t\)\ C[1]\ Sin[t] + 
      36\/325\ Sin[3\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(steadyState[t_] = 
      soln[t] /. {C[1] \[Rule] 0, C[2] \[Rule] 0}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\/325\ Cos[3\ t] + 36\/325\ Sin[3\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"c1c2", "=", 
      RowBox[{"Solve", "[", 
        RowBox[{"{", 
          RowBox[{\(soln[0] == 1\/2\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["soln", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
          "}"}], "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{C[1] \[Rule] 747\/650, C[2] \[Rule] 321\/650}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(x[t_] = 
      soln[t] /. c1c2\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(321\/650\ \[ExponentialE]\^\(\(-3\)\ t\)\ Cos[t] + 2\/325\ Cos[3\ t] + 
      747\/650\ \[ExponentialE]\^\(\(-3\)\ t\)\ Sin[t] + 
      36\/325\ Sin[3\ t]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{\(L[t, x] == 2\ Cos[3\ t]\), "&&", \(x[0] == 1\/2\), "&&", 
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x[t], {t, 0, 5}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.12161 0.963417 [
[.21429 .10911 -3 -9 ]
[.21429 .10911 3 0 ]
[.40476 .10911 -3 -9 ]
[.40476 .10911 3 0 ]
[.59524 .10911 -3 -9 ]
[.59524 .10911 3 0 ]
[.78571 .10911 -3 -9 ]
[.78571 .10911 3 0 ]
[.97619 .10911 -3 -9 ]
[.97619 .10911 3 0 ]
[.01131 .02527 -24 -4.5 ]
[.01131 .02527 0 4.5 ]
[.01131 .21795 -18 -4.5 ]
[.01131 .21795 0 4.5 ]
[.01131 .31429 -18 -4.5 ]
[.01131 .31429 0 4.5 ]
[.01131 .41064 -18 -4.5 ]
[.01131 .41064 0 4.5 ]
[.01131 .50698 -18 -4.5 ]
[.01131 .50698 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .12161 m
.21429 .12786 L
s
[(1)] .21429 .10911 0 1 Mshowa
.40476 .12161 m
.40476 .12786 L
s
[(2)] .40476 .10911 0 1 Mshowa
.59524 .12161 m
.59524 .12786 L
s
[(3)] .59524 .10911 0 1 Mshowa
.78571 .12161 m
.78571 .12786 L
s
[(4)] .78571 .10911 0 1 Mshowa
.97619 .12161 m
.97619 .12786 L
s
[(5)] .97619 .10911 0 1 Mshowa
.125 Mabswid
.0619 .12161 m
.0619 .12536 L
s
.1 .12161 m
.1 .12536 L
s
.1381 .12161 m
.1381 .12536 L
s
.17619 .12161 m
.17619 .12536 L
s
.25238 .12161 m
.25238 .12536 L
s
.29048 .12161 m
.29048 .12536 L
s
.32857 .12161 m
.32857 .12536 L
s
.36667 .12161 m
.36667 .12536 L
s
.44286 .12161 m
.44286 .12536 L
s
.48095 .12161 m
.48095 .12536 L
s
.51905 .12161 m
.51905 .12536 L
s
.55714 .12161 m
.55714 .12536 L
s
.63333 .12161 m
.63333 .12536 L
s
.67143 .12161 m
.67143 .12536 L
s
.70952 .12161 m
.70952 .12536 L
s
.74762 .12161 m
.74762 .12536 L
s
.82381 .12161 m
.82381 .12536 L
s
.8619 .12161 m
.8619 .12536 L
s
.9 .12161 m
.9 .12536 L
s
.9381 .12161 m
.9381 .12536 L
s
.25 Mabswid
0 .12161 m
1 .12161 L
s
.02381 .02527 m
.03006 .02527 L
s
[(-0.1)] .01131 .02527 1 0 Mshowa
.02381 .21795 m
.03006 .21795 L
s
[(0.1)] .01131 .21795 1 0 Mshowa
.02381 .31429 m
.03006 .31429 L
s
[(0.2)] .01131 .31429 1 0 Mshowa
.02381 .41064 m
.03006 .41064 L
s
[(0.3)] .01131 .41064 1 0 Mshowa
.02381 .50698 m
.03006 .50698 L
s
[(0.4)] .01131 .50698 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04454 m
.02756 .04454 L
s
.02381 .06381 m
.02756 .06381 L
s
.02381 .08307 m
.02756 .08307 L
s
.02381 .10234 m
.02756 .10234 L
s
.02381 .14088 m
.02756 .14088 L
s
.02381 .16015 m
.02756 .16015 L
s
.02381 .17942 m
.02756 .17942 L
s
.02381 .19868 m
.02756 .19868 L
s
.02381 .23722 m
.02756 .23722 L
s
.02381 .25649 m
.02756 .25649 L
s
.02381 .27576 m
.02756 .27576 L
s
.02381 .29503 m
.02756 .29503 L
s
.02381 .33356 m
.02756 .33356 L
s
.02381 .35283 m
.02756 .35283 L
s
.02381 .3721 m
.02756 .3721 L
s
.02381 .39137 m
.02756 .39137 L
s
.02381 .4299 m
.02756 .4299 L
s
.02381 .44917 m
.02756 .44917 L
s
.02381 .46844 m
.02756 .46844 L
s
.02381 .48771 m
.02756 .48771 L
s
.02381 .52625 m
.02756 .52625 L
s
.02381 .54551 m
.02756 .54551 L
s
.02381 .56478 m
.02756 .56478 L
s
.02381 .58405 m
.02756 .58405 L
s
.02381 .006 m
.02756 .006 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60326 L
.02605 .60312 L
.02729 .60285 L
.02846 .6025 L
.03053 .60164 L
.03279 .60039 L
.0379 .59647 L
.04262 .59167 L
.05224 .57904 L
.06244 .56244 L
.10458 .47453 L
.14241 .38131 L
.1827 .27382 L
.22147 .17185 L
.24118 .12548 L
.2627 .08258 L
.27267 .06618 L
.28329 .05147 L
.29332 .04042 L
.30241 .03289 L
.30728 .02985 L
.30995 .02848 L
.31243 .0274 L
.31473 .02656 L
.31683 .02593 L
.31916 .02539 L
.32044 .02516 L
.32165 .02498 L
.32285 .02485 L
.32417 .02476 L
.32483 .02473 L
.32554 .02472 L
.32683 .02473 L
.32805 .02478 L
.32933 .02488 L
.33043 .02501 L
.33163 .02518 L
.33434 .02573 L
.33725 .02655 L
.34247 .02862 L
.3478 .03148 L
.35272 .03478 L
.36382 .04438 L
.38397 .06838 L
.42337 .12993 L
.46126 .18785 L
.48071 .20998 L
.48631 .21493 L
.49163 .21896 L
Mistroke
.49686 .22226 L
.5016 .22467 L
.50398 .22567 L
.50655 .22658 L
.50878 .22723 L
.51121 .2278 L
.51247 .22803 L
.51381 .22823 L
.51455 .22832 L
.51523 .22839 L
.51655 .22849 L
.51775 .22854 L
.51906 .22856 L
.5203 .22853 L
.52145 .22847 L
.5225 .22838 L
.52364 .22825 L
.52569 .22793 L
.52814 .22741 L
.53037 .2268 L
.53499 .22512 L
.53985 .22277 L
.54942 .21641 L
.55963 .20728 L
.57801 .18546 L
.61956 .1201 L
.6404 .08573 L
.65959 .05738 L
.67831 .03532 L
.68775 .02693 L
.69307 .02311 L
.69811 .02013 L
.70299 .01785 L
.70556 .01689 L
.7083 .01606 L
.71059 .01552 L
.71181 .01529 L
.71313 .01508 L
.71433 .01493 L
.71543 .01483 L
.71649 .01476 L
.7176 .01472 L
.7189 .01472 L
.72009 .01475 L
.72075 .01478 L
.72147 .01484 L
.72276 .01496 L
.72398 .01512 L
.72527 .01533 L
.72758 .01582 L
Mistroke
.73026 .01657 L
.73278 .01744 L
.7385 .02002 L
.74347 .02293 L
.74889 .02679 L
.75876 .03558 L
.77729 .05747 L
.81796 .12128 L
.85711 .18315 L
.8674 .19645 L
.87854 .20861 L
.88905 .21765 L
.89871 .22365 L
.90342 .22573 L
.906 .22663 L
.90846 .22731 L
.91074 .22781 L
.91194 .22802 L
.91321 .2282 L
.91429 .22832 L
.91547 .22841 L
.91654 .22847 L
.91755 .22849 L
.91876 .22848 L
.92008 .22843 L
.92075 .22838 L
.92146 .22832 L
.92274 .22818 L
.92402 .22799 L
.92523 .22778 L
.9275 .22727 L
.93018 .22649 L
.93264 .22562 L
.93822 .22306 L
.94757 .21702 L
.95631 .20951 L
.97619 .1865 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.625, 174.062},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`00
6oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo0008ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`2_ooooo`Go0000Aoooool0
00Oooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo0:gooooo0_l00004ooooo`?o0000AOooool000Go00000_ooool01?l0003oooooooooool00009
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Z_ooool3o`0000Wooooo0ol00012
ooooo`001oooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Cooooo0_l00019
ooooo`Oo0000F_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo03oooooo0007oooo
o`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`16
ooooo`?o00001_ooool2o`0005Sooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0n
ooooo`001oooool01?l0003oooooooooool00008ooooo`;o00001_ooool00ol0003oooooooooo`15
ooooo`03o`000?oooooooooo00Wooooo0_l0001Eooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool0?Oooool000Sooooo0_l0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0A?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo057ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0looooo`006oooool00ol0003oooooooooo`13ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo03cooooo000Kooooo`;o0000@oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo04gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0kooooo`006ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0C?oo
ool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo03[ooooo000Kooooo`03o`000?oooooo
oooo043ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooo
oooo01Wooooo00?o0000ooooooooool0>Oooool001_ooooo00?o0000ooooooooool0@?ooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool06oooool00ol0
003oooooooooo`0hooooo`006oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo03So
oooo000Kooooo`;o0000?oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo04Gooooo
00?o0000ooooooooool07Oooool00ol0003oooooooooo`0gooooo`006oooool00ol0003ooooooooo
o`0mooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0@oooool00ol0003ooooooooo
o`0Oooooo`03o`000?oooooooooo03Kooooo000Kooooo`03o`000?oooooooooo03gooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool0=_ooool001_ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Loooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0eoooo
o`006oooool00ol0003oooooooooo`0/ooooo`?o00003Oooool00ol0003oooooooooo`0Mooooo`Ko
0000;Oooool3o`0000gooooo00?o0000ooooooooool08?ooool3o`0002gooooo0ol00006ooooo`00
6oooool2o`0002kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Nooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool0:_ooool01Ol0003ooooooooooooooooo000000_o
oooo00?o0000ooooooooool08_ooool2o`0002cooooo00Go0000ooooooooooooooooo`000005oooo
o`006oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool07oooool00ol0003oooooo`00000booooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool08?ooool6o`0002oooooo00?o0000ooooooooool00oooool001_ooooo00?o0000ooooooooool0
;Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo023ooooo00Co0000oooooooooooo
0000;oooool2o`0000_ooooo00?o0000ooooooooool08?ooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo02cooooo00?o0000ooooooooool00oooool001_ooooo00?o0000oooooooo
ool0;Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo023ooooo0_l00002ooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool0:?ooool4o`0000Kooooo000Kooooo`03o`00
0?oooooooooo02cooooo0_l0000;ooooo`03o`000?oooooooooo027ooooo00Go0000ooooool0003o
ooooo`00000/ooooo`05o`000?ooooooooooooooool000002?ooool00ol0003oooooooooo`0Toooo
o`;o00000oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Oooooo000Kooooo`;o
0000;_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02;ooooo0ol0000^ooooo`?o
00002Oooool00ol0003oooooooooo`0Uooooo`05o`000?ooooooooooooooool00000:Oooool5o`00
00Gooooo000Kooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`0gooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0<?ooool001_ooooo
00?o0000ooooooooool0=oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo03Gooooo
00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0_ooooo`006oooool00ol0003ooooooooo
o`0gooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0=Oooool00ol0003ooooooooo
o`0]ooooo`03o`000?oooooooooo02oooooo000Kooooo`03o`000?oooooooooo03Kooooo00?o0000
ooooooooool0:Oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo02oooooo00?o0000
ooooooooool0;_ooool001Goooooool00005o`0000006oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool00009oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooooooool000002Oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`05ooooo`;o00002Ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`04ooooo`006oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool0:?ooool01Ol0003ooooooooooooooooo000002cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool09Oooool00ol0003oooooooooo`04ooooo`006oooool00ol0003oooooooooo`0d
ooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0d
ooooo`03o`000?oooooooooo02_ooooo000Kooooo`03o`000?oooooooooo03Cooooo00?o0000oooo
ooooool0;_ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo03Gooooo00?o0000oooo
ooooool0:oooool001_ooooo0_l0000eooooo`03o`000?oooooooooo02oooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo02[ooooo000Kooooo`03o`00
0?oooooooooo03?ooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0[ooooo`03o`00
0?oooooooooo03Oooooo00?o0000ooooooooool0:_ooool001_ooooo00?o0000ooooooooool0<ooo
ool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0>Ooo
ool00ol0003oooooooooo`0Yooooo`006oooool00ol0003oooooooooo`0booooo`03o`000?oooooo
oooo03?ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooo
oooo02Sooooo000Kooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0<oooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0:?ooool001_o
oooo0_l0000booooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`0mooooo`03o`000?oooooooooo02Oooooo000Kooooo`03o`000?oooooooooo037ooooo
00?o0000ooooooooool0=_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo03kooooo
00?o0000ooooooooool09_ooool001_ooooo00?o0000ooooooooool0<Oooool00ol0003ooooooooo
o`0fooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0?oooool00ol0003ooooooooo
o`0Vooooo`006oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo03Sooooo00?o0000
ooooooooool08_ooool00ol0003oooooooooo`10ooooo`03o`000?oooooooooo02Gooooo000Koooo
o`03o`000?oooooooooo033ooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0Poooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool09Oooool001_ooooo0_l0000`ooooo`03
o`000?oooooooooo03[ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`13ooooo`03
o`000?oooooooooo02Cooooo000Kooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0
>oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0
8oooool001_ooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00Cooooo000Kooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool0?Oooool0
0ol0003oooooooooo`0Kooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`04ooooo`006oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo
03kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool01Oooool001_ooooo0_l0000^ooooo`03o`000?oooooooooo043o
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`1;ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool01_ooool001_ooooo00?o0000ooooooooool0;Oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo00Oooooo0008ooooo`;o00001?ooool00ol0003ooooooooo
o`02ooooo`?o00001Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo04;ooooo00?o
0000ooooooooool04oooool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool02?ooool000Oooooo00Co0000oooooooooooo00002Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0A?ooool2o`0001;ooooo00?o
0000ooooooooool0DOooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Wooooo0007
ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0/ooooo`03o`000?oooooooooo04Kooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`1Cooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02_ooool000Oooooo00Co0000
oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`;o0000;Oooool00ol0003ooooooooo
o`17ooooo`;o00003?ooool2o`0005Oooooo0ol0000<ooooo`;o00003Oooool000Oooooo00Co0000
oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02_ooooo00?o
0000ooooooooool0B_ooool00ol0003oooooooooo`07ooooo`;o0000G?ooool00ol0003ooooooooo
o`07ooooo`;o00003oooool000Oooooo00Co0000oooooooooooo00002?ooool2o`0000Kooooo00?o
0000ooooooooool0:oooool00ol0003oooooooooo`1;ooooo`?o00001?ooool2o`0005oooooo0_l0
0004ooooo`?o00004Oooool000Sooooo0_l0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0:_ooool00ol0003oooooooooo`1>ooooo`Go0000Hoooool5o`0001?ooooo000Koooo
o`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0c_ooool001_ooooo0_l0000[ooooo`03
o`000?oooooooooo0<kooooo000Kooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0
coooool001_ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`3?ooooo`006oooool0
0ol0003oooooooooo`0Xooooo`03o`000?oooooooooo0=3ooooo000Kooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool0d?ooool001_ooooo0_l0000Yooooo`03o`000?oooooooooo0=3o
oooo000Kooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0dOooool001_ooooo00?o
0000ooooooooool09oooool00ol0003oooooooooo`3Aooooo`006oooool00ol0003oooooooooo`0W
ooooo`03o`000?oooooooooo0=7ooooo000Kooooo`03o`000?oooooooooo02Kooooo00?o0000oooo
ooooool0d_ooool001_ooooo0_l0000Wooooo`03o`000?oooooooooo0=;ooooo000Kooooo`03o`00
0?oooooooooo02Gooooo00?o0000ooooooooool0doooool001_ooooo00?o0000ooooooooool09Ooo
ool00ol0003oooooooooo`3Cooooo`006oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooo
oooo0=?ooooo000Kooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0e?ooool001_o
oooo0_l0000Uooooo`03o`000?oooooooooo0=Cooooo000Kooooo`03o`000?oooooooooo02Cooooo
00?o0000ooooooooool0e?ooool000Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go0000
1?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo0=Gooooo0007ooooo`04o`000?oo
ooooooooo`0000Sooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0Sooooo`03
o`000?oooooooooo0=Gooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo0=Gooooo0007ooooo`04o`00
0?ooooooooooo`0000[ooooo00?o0000ooooooooool00oooool2o`0002?ooooo00?o0000oooooooo
ool0e_ooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`3Fooooo`001oooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0R
ooooo`03o`000?oooooooooo0=Kooooo0008ooooo`;o00002Oooool3o`0000Gooooo00?o0000oooo
ooooool08Oooool00ol0003oooooooooo`3Gooooo`006oooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo0=Oooooo000Kooooo`;o00008Oooool00ol0003oooooooooo`3Hooooo`006ooo
ool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo0=Sooooo000Kooooo`03o`000?oooooo
oooo023ooooo00?o0000ooooooooool0f?ooool001_ooooo00?o0000ooooooooool07oooool00ol0
003oooooooooo`3Iooooo`006oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo0=Wo
oooo000Kooooo`;o00008?ooool00ol0003oooooooooo`3Iooooo`006oooool00ol0003ooooooooo
o`0Nooooo`03o`000?oooooooooo0=[ooooo000Kooooo`03o`000?oooooooooo01kooooo00?o0000
ooooooooool0f_ooool001_ooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`3Joooo
o`006oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo0=_ooooo000Kooooo`;o0000
7_ooool00ol0003oooooooooo`3Kooooo`006oooool00ol0003oooooooooo`0Mooooo`03o`000?oo
oooooooo0=_ooooo000Kooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0g?ooool0
01_ooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`3Looooo`006oooool00ol0003o
ooooooooo`0Kooooo`03o`000?oooooooooo0=gooooo000Kooooo`;o00007?ooool00ol0003ooooo
ooooo`3Mooooo`006oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo0=gooooo000K
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0g_ooool000Sooooo0_l00004oooo
o`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo01[ooooo00?o0000oooo
ooooool0g_ooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3Oooooo`001oooool01?l0
003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo0_l0000Jooooo`03o`000?oooooo
oooo0=oooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo0_l00005ooooo`03o`000?oooooo
oooo01Wooooo00?o0000ooooooooool0goooool000Oooooo00Co0000oooooooooooo00002oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0h?ooool0
00Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`3Pooooo`002?ooool2o`0000Wooooo0ol00005
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0hOooool001_ooooo0_l0000Hoooo
o`03o`000?oooooooooo0>7ooooo000Kooooo`03o`000?oooooooooo01Oooooo00?o0000oooooooo
ool0hOooool001_ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`3Rooooo`006ooo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0>;ooooo000Kooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool0hoooool001_ooooo0_l0000Fooooo`03o`000?oooooooooo
0>?ooooo000Kooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0hoooool001_ooooo
00?o0000ooooooooool05?ooool00ol0003oooooooooo`3Tooooo`006oooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo0>Cooooo000Kooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool0iOooool001_ooooo0_l0000Dooooo`03o`000?oooooooooo0>Gooooo000Kooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool0iOooool001_ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`3Vooooo`006oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo0>Kooooo000Kooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ioooool0
01_ooooo0_l0000Booooo`03o`000?oooooooooo0>Oooooo000Kooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool0j?ooool001_ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`3Xooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool00oooool3o`0000Cooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`3Yooooo`001oooool01?l0003oooooooooool0
000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`3Yooooo`001oooool01?l0003oooooooooool00007ooooo`Go00001?ooool2o`0000oooooo00?o
0000ooooooooool0j_ooool000Oooooo00Co0000oooooooooooo00001oooool01?l0003ooooooooo
ool00005ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0j_ooool000Oooooo00Co
0000oooooooooooo00002?ooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool0joooool000Oooooo00Co0000oooooooooooo00002Oooool2o`0000Gooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`3[ooooo`002?ooool2o`0000_ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0>cooooo000K
ooooo`;o00003Oooool00ol0003oooooooooo`3/ooooo`006oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo0>gooooo000Kooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0kOooool001_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`3^ooooo`006ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0>kooooo000Kooooo`;o00002_ooool0
0ol0003oooooooooo`3_ooooo`006oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
0>oooooo000Kooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0l?ooool001_ooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`3`ooooo`006oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo0?7ooooo000Kooooo`;o00002?ooool00ol0003oooooooooo`3a
ooooo`006oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?;ooooo000Kooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0loooool001_ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`3cooooo`006oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo0?Cooooo000Kooooo`;o00001Oooool00ol0003oooooooooo`3dooooo`006oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo0?Gooooo000Kooooo`04o`000?oooooooooooooo
o`;o0000n?ooool000Sooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`04
o`000?ooooooooooo`000?[ooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooo00000?_ooooo0007ooooo`04o`000?oooooooooo
o`0000_ooooo00?o0000ooooooooool00_ooool2o`000?cooooo0007ooooo`04o`000?oooooooooo
o`0000_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3kooooo`001oooool01?l0
003oooooooooool00007ooooo`Co00001Oooool00ol0003oooooooooo`3kooooo`001oooool01?l0
003oooooooooool00007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0noooool0
00Sooooo0_l00008ooooo`Go00001?ooool00ol0003oooooooooo`3kooooo`00oooooolJooooo`00
oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00
\
\>"],
  ImageRangeCache->{{{0, 280.625}, {173.062, 0}} -> {-0.551089, -0.150154, \
0.0202267, 0.003999}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x[t] - steadyState[t], {t, 0, 5}, 
      PlotRange \[Rule] {\(-\(1\/2\)\), 1\/2}]\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.309017 0.618034 [
[.21429 .29652 -3 -9 ]
[.21429 .29652 3 0 ]
[.40476 .29652 -3 -9 ]
[.40476 .29652 3 0 ]
[.59524 .29652 -3 -9 ]
[.59524 .29652 3 0 ]
[.78571 .29652 -3 -9 ]
[.78571 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .0618 -24 -4.5 ]
[.01131 .0618 0 4.5 ]
[.01131 .18541 -24 -4.5 ]
[.01131 .18541 0 4.5 ]
[.01131 .43262 -18 -4.5 ]
[.01131 .43262 0 4.5 ]
[.01131 .55623 -18 -4.5 ]
[.01131 .55623 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(1)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(2)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(3)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(4)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .0618 m
.03006 .0618 L
s
[(-0.4)] .01131 .0618 1 0 Mshowa
.02381 .18541 m
.03006 .18541 L
s
[(-0.2)] .01131 .18541 1 0 Mshowa
.02381 .43262 m
.03006 .43262 L
s
[(0.2)] .01131 .43262 1 0 Mshowa
.02381 .55623 m
.03006 .55623 L
s
[(0.4)] .01131 .55623 1 0 Mshowa
.125 Mabswid
.02381 .09271 m
.02756 .09271 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .61423 m
.06244 .54956 L
.10458 .46887 L
.12507 .43548 L
.14415 .40906 L
.18221 .3693 L
.20263 .35409 L
.2212 .34325 L
.24035 .33454 L
.26113 .32736 L
.28097 .32225 L
.302 .31827 L
.32153 .31557 L
.33983 .31371 L
.36008 .31221 L
.3786 .31123 L
.39759 .31052 L
.40834 .31021 L
.41831 .30997 L
.42888 .30977 L
.43884 .30961 L
.45744 .30939 L
.46721 .3093 L
.47752 .30923 L
.49599 .30913 L
.50547 .3091 L
.51563 .30907 L
.52522 .30905 L
.53397 .30903 L
.54388 .30902 L
.55305 .30901 L
.56312 .309 L
.5682 .309 L
.57381 .309 L
.57873 .309 L
.5839 .30899 L
.58832 .30899 L
.59316 .30899 L
.59589 .30899 L
.59838 .30899 L
.59976 .30899 L
.60125 .30899 L
.60194 .30899 L
.60266 .30899 L
.60396 .30899 L
.60515 .30899 L
.60643 .30899 L
.60764 .30899 L
.60875 .30899 L
.61004 .30899 L
Mistroke
.61145 .30899 L
.61401 .30899 L
.61658 .30899 L
.61934 .30899 L
.62436 .30899 L
.63373 .30899 L
.65471 .309 L
.69577 .309 L
.73531 .30901 L
.77333 .30901 L
.79288 .30901 L
.81381 .30901 L
.83509 .30901 L
.85522 .30902 L
.87517 .30902 L
.8936 .30902 L
.9123 .30902 L
.93292 .30902 L
.95231 .30902 L
.97318 .30902 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.625, 174.062},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003ooooo
ooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3k
ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`00
6oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2
o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo0008
ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`3k
ooooo`001oooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0noooool000Go00000_ooool01?l0003oooooooooool00007ooooo`Go00001?ooool0
0ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00007ooooo`04o`000?oooooo
ooooo`0000Gooooo0_l0003looooo`001oooool01?l0003oooooooooool00008ooooo`03o`000?oo
oooo000000Gooooo00?o0000ooooooooool0noooool000Oooooo00Co0000oooooooooooo00002Ooo
ool2o`0000Gooooo00?o0000ooooooooool0noooool000Sooooo0_l0000;ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_o
oooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o
0000ooooooooool0noooool001_ooooo0_l0003looooo`006oooool00ol0003oooooooooo`3koooo
o`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
ool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0
003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool2o`000?cooooo
000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Koooo
o`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`00
0?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooo
oooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000ooooooooool0noooool001_ooooo
00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000
ooooooooool0noooool000Sooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00001?ooool0
0ol0003oooooooooo`3kooooo`001oooool01?l0003oooooooooool00008ooooo`04o`000?oooooo
ooooo`0000Cooooo00?o0000ooooooooool0noooool000Go00000_ooool01?l0003oooooooooool0
0009ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0noooool000Oooooo00Co0000
oooooooooooo00002_ooool00ol0003oooooooooo`03ooooo`;o0000o?ooool000Oooooo00Co0000
oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0
noooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooooooool0noooool000Sooooo0_l00009ooooo`?o00001Oooool00ol0003ooooo
ooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3k
ooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`00
6oooool2o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooo
oooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000K
ooooo`03o`000?oooooooooo0?_ooooo000Kooooo`;o0000o?ooool001_ooooo00?o0000oooooooo
ool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0nooo
ool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0;?ooool3o`00
02kooooo1Ol0000]ooooo`?o0000<?ooool3o`0002gooooo0ol00006ooooo`006oooool00ol0003o
ooooooooo`0]ooooo`03o`000?oooooooooo02kooooo00Co0000oooooooooooo0000;?ooool01Ol0
003ooooooooooooooooo0000033ooooo00?o0000ooooooooool0:oooool01Ol0003ooooooooooooo
oooo000000Gooooo000Kooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0;oooool0
0ol0003oooooooooo`0`ooooo`03o`000?oooooooooo02_ooooo1Ol0000`ooooo`03o`000?oooooo
oooo00?ooooo000Kooooo`;o0000;_ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo
02gooooo0_l0000^ooooo`04o`000?ooooooooooo`00037ooooo00?o0000ooooooooool00oooool0
01_ooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0]ooooo`05o`000?oooooooooo
ooooool00000<?ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooo000002gooooo1?l00006
ooooo`006oooool00ol0003oooooooooo`0/ooooo`;o0000;oooool01Ol0003ooooooooooooooooo
000002cooooo00Go0000ooooooooooooooooo`00000_ooooo`;o0000;Oooool00ol0003ooooooooo
o`07ooooo`006oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo02kooooo0ol0000^
ooooo`?o0000<Oooool00ol0003oooooooooo`0[ooooo`Go00001Oooool001_ooooo00?o0000oooo
ooooool0noooool001_ooooo00?o0000ooooooooool0noooool001_ooooo00?o0000ooooooooool0
noooool001_ooooo00?o0000ooooooooool0noooool001Goooooool00005o`0000006oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo4?l00004ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Cooooo000Kooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool04Oooool;o`0001?o
oooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02ko
oooo00?o0000ooooooooool01?ooool001_ooooo00?o0000ooooooooool0?_ooool4o`000;Wooooo
000Kooooo`03o`000?oooooooooo03_ooooo0ol0002mooooo`006oooool00ol0003oooooooooo`0i
ooooo`;o0000`?ooool001_ooooo00?o0000ooooooooool0=_ooool3o`000<;ooooo000Kooooo`03
o`000?oooooooooo03Cooooo0_l00035ooooo`006oooool2o`0003;ooooo0ol00037ooooo`006ooo
ool00ol0003oooooooooo`0_ooooo`;o0000b_ooool001_ooooo00?o0000ooooooooool0;Oooool2
o`000<cooooo000Kooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0c?ooool001_o
oooo00?o0000ooooooooool0:_ooool2o`000<oooooo000Kooooo`03o`000?oooooooooo02Wooooo
00?o0000ooooooooool0coooool001_ooooo00?o0000ooooooooool0:?ooool00ol0003ooooooooo
o`3@ooooo`006oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo0=7ooooo000Koooo
o`;o00009oooool00ol0003oooooooooo`3Booooo`006oooool00ol0003oooooooooo`0Uooooo`03
o`000?oooooooooo0=?ooooo000Kooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0
e?ooool001_ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`3Eooooo`006oooool0
0ol0003oooooooooo`0Rooooo`03o`000?oooooooooo0=Kooooo000Kooooo`03o`000?oooooooooo
027ooooo00?o0000ooooooooool0eoooool001_ooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`3Hooooo`006oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo0=Wooooo
000Kooooo`;o00007oooool00ol0003oooooooooo`3Jooooo`006oooool00ol0003oooooooooo`0M
ooooo`03o`000?oooooooooo0=_ooooo000Kooooo`03o`000?oooooooooo01cooooo00?o0000oooo
ooooool0g?ooool001_ooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`3Looooo`00
6oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo0=gooooo000Kooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool0g_ooool000Sooooo0_l00004ooooo`04o`000?oooooo
ooooooooo`Go00001?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo0=oooooo0007
ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00001?ooool00ol0003ooooo
ooooo`0Iooooo`03o`000?oooooooooo0=oooooo0007ooooo`04o`000?ooooooooooo`0000Wooooo
00?o0000ooooooooool01?ooool2o`0001Wooooo00?o0000ooooooooool0h?ooool000Oooooo00Co
0000oooooooooooo00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool0hOooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooo
oooooooooooo000000Cooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`3Qooooo`00
1oooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo0>;ooooo0008ooooo`;o00002Oooool3o`0000Go
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`3Sooooo`006oooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo0>?ooooo000Kooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool0i?ooool001_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`3T
ooooo`006oooool2o`0001Cooooo00?o0000ooooooooool0iOooool001_ooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`3Vooooo`006oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo0>Kooooo000Kooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0iooo
ool001_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`3Wooooo`006oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo0>Sooooo000Kooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool0j?ooool001_ooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`3Yooooo`006oooool2o`00013ooooo00?o0000ooooooooool0jOooool001_ooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`3Zooooo`006oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo0>[ooooo000Kooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool0joooool001_ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`3/ooooo`006ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo0>cooooo000Kooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool0kOooool001_ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`3]ooooo`006oooool2o`0000_ooooo00?o0000ooooooooool0k_ooool001_ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`3^ooooo`006oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo0>oooooo000Kooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool0koooool001_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`3`oooo
o`006oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?3ooooo0008ooooo`;o0000
1?ooool00ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo0?7ooooo0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?7ooooo0007ooooo`04o`000?oo
ooooooooo`0000Oooooo1Ol00004ooooo`;o00001oooool00ol0003oooooooooo`3booooo`001ooo
ool01?l0003oooooooooool00007ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`3booooo`001oooool01?l0003oooooooooool00008ooooo`03
o`000?oooooo000000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3cooooo`00
1oooool01?l0003oooooooooool00009ooooo`;o00001Oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo0?Cooooo0008ooooo`;o00002oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0m?ooool001_ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`3eooooo`006oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0?Gooooo000Kooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0m_ooool001_o
oooo0_l00002ooooo`03o`000?oooooooooo0?Oooooo000Kooooo`05o`000?ooooooooooooooool0
0000nOooool001_ooooo00Co0000oooooooooooo0000n_ooool001_ooooo00Co0000oooooooooooo
0000n_ooool001_ooooo00?o0000ooooool00000noooool001_ooooo0_l0003looooo`006oooool2
o`000?cooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_o
oooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[o
oooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.625}, {173.062, 0}} -> {-0.551089, -0.539422, \
0.0202267, 0.0062338}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{52, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 96, 2, 65, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1897, 59, 80, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2002, 65, 433, 11, 43, "Input"],
Cell[2438, 78, 321, 8, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2796, 91, 112, 2, 27, "Input"],
Cell[2911, 95, 472, 8, 125, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3420, 108, 186, 5, 43, "Input"],
Cell[3609, 115, 180, 3, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3826, 123, 127, 3, 27, "Input"],
Cell[3956, 128, 72, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4065, 134, 370, 10, 42, "Input"],
Cell[4438, 146, 82, 1, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4557, 152, 132, 3, 27, "Input"],
Cell[4692, 157, 188, 3, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4917, 165, 320, 8, 42, "Input"],
Cell[5240, 175, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5315, 181, 81, 2, 27, "Input"],
Cell[5399, 185, 23552, 618, 183, 5676, 391, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[28954, 805, 130, 3, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[29121, 813, 146, 3, 62, "Input"],
Cell[29270, 818, 15105, 422, 183, 4008, 279, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[44378, 1242, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

